import { Request, Response } from "express";
import { Marquee } from "../models/MarqueeModel";

// ✅ Get all marquees
export const fetchAllMarquees = async (req: Request, res: Response): Promise<void> => {
  try {
    const marquees = await Marquee.findAll({ order: [["created_at", "DESC"]] });
    res.status(200).json({ success: true, data: marquees });
  } catch (error: any) {
    console.error("Error fetching marquees:", error);
    res.status(500).json({ success: false, message: error.message });
  }
};

// ✅ Add new marquee
export const addMarquee = async (req: Request, res: Response): Promise<void> => {
  try {
    const { marquee_text, banner } = req.body;
    await Marquee.create({ marquee_text, banner: banner || null });
    res.status(201).json({ success: true, message: "Marquee added successfully" });
  } catch (error: any) {
    console.error("Error adding marquee:", error);
    res.status(500).json({ success: false, message: error.message });
  }
};

// ✅ Update marquee
export const updateMarquee = async (req: Request, res: Response): Promise<void> => {
  try {
    const { id } = req.params;
    const { marquee_text, banner } = req.body;

    const marquee = await Marquee.findByPk(Number(id));
    if (!marquee) {
      res.status(404).json({ success: false, message: "Marquee not found" });
      return;
    }

    await marquee.update({ marquee_text, banner: banner || null });
    res.status(200).json({ success: true, message: "Marquee updated successfully" });
  } catch (error: any) {
    console.error("Error updating marquee:", error);
    res.status(500).json({ success: false, message: error.message });
  }
};

// ✅ Delete marquee
export const deleteMarquee = async (req: Request, res: Response): Promise<void> => {
  try {
    const { id } = req.params;
    const marquee = await Marquee.findByPk(Number(id));

    if (!marquee) {
      res.status(404).json({ success: false, message: "Marquee not found" });
      return;
    }

    await marquee.destroy();
    res.status(200).json({ success: true, message: "Marquee deleted successfully" });
  } catch (error: any) {
    console.error("Error deleting marquee:", error);
    res.status(500).json({ success: false, message: error.message });
  }
};
