// import express from 'express';
// import { ErrorRequestHandler } from 'express';
// import dotenv from 'dotenv';
// import useragent from 'express-useragent';
// import cors from 'cors';
// import astrologerRoute from './routes/astrologerRoutes';
// import userRoute from './routes/userRoutes';
// import bpartnerRoute from './routes/bpartnerRoutes';
// import servicesRoute from './routes/servicesRoutes';
// import adminRoute from './routes/adminRoutes';
// import kundaliapi from './routes/kundaliapi';
// import marqueeRoutes from "./routes/marqueeRoutes";
// import panditRoute from "./routes/panditRoutes";



// dotenv.config();
// const app = express();

// app.use(cors({
//   // origin: '*', 
//     origin: ["http://localhost:5173", "https://localhost:5173"],
//   credentials: true,               
// }));

// app.use(useragent.express());
// app.use(express.json());
// app.use(express.urlencoded({ extended: true }));

// // Health check endpoint for Vercel
// app.get('/health', (req, res) => {
//   res.status(200).json({ 
//     status: 'OK', 
//     message: 'Server is running',
//     timestamp: new Date().toISOString()
//   });
// });

// app.use((req, res, next) => {
// // console.log(JSON.stringify({
// //   time: new Date().toISOString(),
// //   method: req.method,
// //   path: req.url,
// //   ip: req.ip,
// //   userAgent: req.headers['user-agent']
// // }));

//   next();
// });

// // Static file serving - using relative paths for Vercel
// app.use('/uploads', express.static('./uploads'));
// app.use('/pooja_image', express.static('./pooja_image'));
// app.use('/user_profile', express.static('./user_profile'));

// app.use('/api/auth/astrologer', astrologerRoute);
// app.use('/api/auth/user', userRoute);
// app.use('/api/auth/bpartner', bpartnerRoute);
// app.use('/api/auth/admin', adminRoute);
// app.use('/v1', servicesRoute);
// app.use('/v2', kundaliapi);

// app.use("/api/auth/pandit", panditRoute);

// app.use("/api/marquee", marqueeRoutes);



// const errorHandler: ErrorRequestHandler = (err: any, req: express.Request, res: express.Response, next: express.NextFunction) => {
//   if (err instanceof SyntaxError && 'body' in err) {
//     res.status(400).json({
//       success: false,
//       message: 'Invalid JSON format in request body'
//     });
//     return;
//   }
//   next(err);
// };

// app.use(errorHandler);

// export default app;


import express, { ErrorRequestHandler, Request, Response, NextFunction } from "express";
import dotenv from "dotenv";
import useragent from "express-useragent";
import './services/freeSlotsCron';

// Routes
import astrologerRoute from "./routes/astrologerRoutes";
import userRoute from "./routes/userRoutes";
import bpartnerRoute from "./routes/bpartnerRoutes";
import servicesRoute from "./routes/servicesRoutes";
import adminRoute from "./routes/adminRoutes";
import kundaliapi from "./routes/kundaliapi";
import marqueeRoutes from "./routes/marqueeRoutes";
import panditRoute from "./routes/panditRoutes";
import yogaTrainerRoutes from "./routes/yogaTrainerRoutes";
import astrologerFreeSlotRoutes  from "./routes/astrologerFreeSlotRoutes";
import payoutRoutes from "./routes/payoutRoutes";

dotenv.config();

const app = express();

// --------------------------------------
//  FIXED CORS (Manual like in dist code)
// --------------------------------------
const allowedOrigins = [
  "https://navambhaw.com",
  "https://www.navambhaw.com",
  "https://localhost:5173",
  "http://localhost:5173",
];

app.use((req: Request, res: Response, next: NextFunction): void => {
  const origin = req.headers.origin as string;

  if (allowedOrigins.includes(origin)) {
    res.header("Access-Control-Allow-Origin", origin);
  }

  res.header("Access-Control-Allow-Credentials", "true");
  res.header("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
  res.header(
    "Access-Control-Allow-Headers",
    "Content-Type, Authorization, X-Requested-With"
  );

  if (req.method === "OPTIONS") {
    res.sendStatus(200);
    return; // important for TS
  }

  next();
});


// ----------------------------
// Middlewares
// ----------------------------
app.use(useragent.express());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// Health Check
app.get("/health", (req: Request, res: Response) => {
  res.status(200).json({
    status: "OK",
    message: "Server is running",
    timestamp: new Date().toISOString(),
  });
});

// Static files
app.use("/uploads", express.static("./uploads"));
app.use("/pooja_image", express.static("./pooja_image"));
app.use("/user_profile", express.static("./user_profile"));

// API Routes
app.use("/api/auth/astrologer", astrologerRoute);
app.use("/api/auth/user", userRoute);
app.use("/api/auth/bpartner", bpartnerRoute);
app.use("/api/auth/admin", adminRoute);
app.use("/v1", servicesRoute);
app.use("/v2", kundaliapi);
app.use("/api/auth/pandit", panditRoute);
app.use("/api/marquee", marqueeRoutes);
app.use('/api/auth/yoga', yogaTrainerRoutes);
app.use('/api/astrologer/free-slots', astrologerFreeSlotRoutes);
app.use("/v3", payoutRoutes);


// ----------------------------
// Error Handler
// ----------------------------
const errorHandler: ErrorRequestHandler = (
  err: any,
  req: Request,
  res: Response,
  next: NextFunction
) => {
  if (err instanceof SyntaxError && "body" in err) {
    res.status(400).json({
      success: false,
      message: "Invalid JSON format in request body",
    });
    return;
  }
  next(err);
};

app.use(errorHandler);

export default app;
