# Auth App - Vercel Deployment

This is a Node.js/Express TypeScript application configured for deployment on Vercel.

## 🚀 Deployment on Vercel

### Prerequisites
- Vercel account
- Git repository with your code
- Environment variables configured

### Steps to Deploy

1. **Install Vercel CLI** (optional):
   ```bash
   npm i -g vercel
   ```

2. **Deploy via Vercel Dashboard**:
   - Go to [vercel.com](https://vercel.com)
   - Import your Git repository
   - Vercel will automatically detect the Node.js configuration

3. **Configure Environment Variables**:
   In your Vercel project settings, add these environment variables:
   ```
   DB_HOST=your_database_host
   DB_USER=your_database_user
   DB_PASSWORD=your_database_password
   DB_NAME=your_database_name
   DB_PORT=3306
   JWT_SECRET=your_jwt_secret_key
   JWT_EXPIRES_IN=24h
   NODE_ENV=production
   UPSTASH_REDIS_REST_URL=your_redis_url
   UPSTASH_REDIS_REST_TOKEN=your_redis_token
   MONGODB_URI=your_mongodb_connection_string
   CRON_SECRET=your_cron_secret_key
   URL_SOCKET=your_redis_socket_url
   TOKEN_SOCKET=your_redis_socket_token
   ```

### 📁 Project Structure

```
auth-app/
├── api/
│   └── index.ts          # Vercel serverless entry point
├── config/
│   └── db.ts            # Database configuration
├── controllers/          # Route controllers
├── middleware/           # Express middleware
├── models/              # Database models
├── routes/              # API routes
├── services/            # Business logic
├── app.ts               # Express app configuration
├── server.ts            # Local development server
├── vercel.json          # Vercel configuration
└── package.json         # Dependencies and scripts
```

### 🔧 Available Scripts

- `npm run dev` - Start development server
- `npm run build` - Build TypeScript to JavaScript
- `npm start` - Start production server
- `npm run vercel-build` - Build for Vercel deployment

### 🌐 API Endpoints

- `GET /health` - Health check endpoint
- `POST /api/auth/user/*` - User authentication routes
- `POST /api/auth/astrologer/*` - Astrologer routes
- `POST /api/auth/bpartner/*` - Business partner routes
- `POST /api/auth/admin/*` - Admin routes
- `GET /v1/*` - Services routes
- `GET /v2/*` - Kundali API routes
- `POST /api/cron` - Cron job endpoint (automated panchang fetching)
- `POST /api/trigger-cron` - Manual trigger for cron job (testing)

### 📝 Important Notes

1. **Static Files**: The app serves static files from relative paths:
   - `/uploads` → `./uploads/`
   - `/pooja_image` → `./pooja_image/`
   - `/user_profile` → `./user_profile/`

2. **Database**: Ensure your database is accessible from Vercel's servers (use cloud database)

3. **File Uploads**: For production, consider using cloud storage (AWS S3, Cloudinary, etc.) instead of local file storage

4. **CORS**: Currently configured to allow all origins (`*`). Update for production security.

5. **Cron Jobs**: The app includes automated panchang fetching that runs daily at 7:15 AM UTC

### 🔍 Troubleshooting

- Check Vercel function logs for errors
- Verify environment variables are set correctly
- Ensure database connection is working
- Test the `/health` endpoint to verify deployment

### 📞 Support

For deployment issues, check:
- Vercel documentation: https://vercel.com/docs
- Function logs in Vercel dashboard
- Environment variable configuration
